<?php

use Tygh\Development;
use Tygh\Registry;
use Tygh\Helpdesk;

if ($_SERVER['REQUEST_METHOD'] == 'POST')
{

    if (!empty($_REQUEST['user_email'])) {
        $_REQUEST['user_login'] = $_REQUEST['user_email'];
    }

    if ($mode == 'login') {

        $redirect_url = '';

        fn_restore_processed_user_password($_REQUEST, $_POST);

        list($status, $user_data, $user_login, $password, $salt) = fn_auth_routines($_REQUEST, $auth);

        if (!empty($_REQUEST['redirect_url'])) {
            $redirect_url = $_REQUEST['redirect_url'];
        } else {
            $redirect_url = fn_url('auth.login' . !empty($_REQUEST['return_url']) ? '?return_url=' . $_REQUEST['return_url'] : '');
        }

        if ($status === false) {
            fn_save_post_data('user_login');

            return array(CONTROLLER_STATUS_REDIRECT, $redirect_url);
        }
        //
        // Success login
        //
        if (!empty($user_data) && (!empty($password) && fn_generate_salted_password($password, $salt) == $user_data['password'] && $_REQUEST['login_type'] != 'sms_code' || $_REQUEST['login_type'] == 'sms_code' && $_REQUEST['sms_code'] == $_SESSION['csc_code'])) {

            // Regenerate session ID for security reasons
            Tygh::$app['session']->regenerateID();

            //
            // If customer placed orders before login, assign these orders to this account
            //
            if (!empty($auth['order_ids'])) {
                foreach ($auth['order_ids'] as $k => $v) {
                    db_query("UPDATE ?:orders SET ?u WHERE order_id = ?i", array('user_id' => $user_data['user_id']), $v);
                }
            }

            fn_login_user($user_data['user_id'], true);

            Helpdesk::auth();

            // Set system notifications
            if (Registry::get('config.demo_mode') != true && AREA == 'A') {
                // If username equals to the password
                if (!fn_is_development() && fn_compare_login_password($user_data, $password)) {
                    $lang_var = 'warning_insecure_password_email';

                    fn_set_notification('E', __('warning'), __($lang_var, array(
                        '[link]' => fn_url('profiles.update')
                    )), 'S', 'insecure_password');
                }
                if (empty($user_data['company_id']) && !empty($user_data['user_id'])) {
                    // Insecure admin script
                    if (!fn_is_development() && Registry::get('config.admin_index') == 'admin.php') {
                        fn_set_notification('E', __('warning'), __('warning_insecure_admin_script', array('[href]' => Registry::get('config.resources.admin_protection_url'))), 'S');
                    }

                    if (!fn_is_development() && is_file(Registry::get('config.dir.root') . '/install/index.php')) {
                        fn_set_notification('W', __('warning'), __('delete_install_folder'), 'S');
                    }

                    if (Development::isEnabled('compile_check')) {
                        fn_set_notification('W', __('warning'), __('warning_store_optimization_dev', array('[link]' => fn_url("themes.manage"))));
                    }

                    fn_set_hook('set_admin_notification', $user_data);
                }

            }

            if (!empty($_REQUEST['remember_me'])) {
                fn_set_session_data(AREA . '_user_id', $user_data['user_id'], COOKIE_ALIVE_TIME);
                fn_set_session_data(AREA . '_password', $user_data['password'], COOKIE_ALIVE_TIME);
            }

            if (!empty($_REQUEST['return_url'])) {
                $redirect_url = $_REQUEST['return_url'];
            }

            unset($_REQUEST['redirect_url']);

            if (AREA == 'C') {
                fn_set_notification('N', __('notice'), __('successful_login'));
            }

            if (AREA == 'A' && Registry::get('runtime.unsupported_browser')) {
                $redirect_url = "upgrade_center.ie7notify";
            }

            unset(Tygh::$app['session']['cart']['edit_step']);

            fn_redirect($redirect_url);

        } else {
            //
            // Login incorrect
            //
            // Log user failed login
            fn_log_event('users', 'failed_login', array (
                'user' => $user_login
            ));

            $auth = fn_fill_auth();
            fn_set_notification('E', __('error'), __('error_incorrect_login'));
            fn_save_post_data('user_login');

            return array(CONTROLLER_STATUS_REDIRECT, $redirect_url);
        }

        unset(Tygh::$app['session']['edit_step']);
    }

    if ($mode == 'recover_password')
    {
        if (!empty($_REQUEST['ekey'])) {
            $ekey = $_REQUEST['ekey'];

            $user_data = fn_recover_password_login($ekey, true);
            if ($user_data) {
                list($user_id, $user_status) = $user_data;
                if ($user_status !== LOGIN_STATUS_USER_NOT_FOUND && $user_status !== LOGIN_STATUS_USER_DISABLED) {
                    $redirect_url = 'profiles.update?user_id=' . $user_id;
                } else {
                    $redirect_url = fn_url();
                }
            } elseif ($user_data === false) {
                $redirect_url = 'auth.recover_password';
            }
            $user_data = fn_get_user_info($user_data[0]);
            return array(CONTROLLER_STATUS_REDIRECT, 'auth.login_form?phone=' . $user_data['email']);
        }
        if (!empty($_REQUEST['user_email']))
        {
            $user_id = db_get_field('select user_id from ?:users where email = ?s', $_REQUEST['user_email']);
            if (!empty($user_id))
            {
                $params = array_merge(array(
                    'ekey'       => '',
                    'user_email' => '',
                ), $_REQUEST);

                $action = $params['ekey']
                    ? 'recover'
                    : 'request';

                $redirect_url = '';

                if ($action === 'request') {
                    $user_email = $params['user_email'];
                    if (!fn_recover_password_generate_key($user_email)) {
                        $redirect_url = 'auth.recover_password';
                    }
                }
                return array(CONTROLLER_STATUS_REDIRECT, 'auth.login_form?phone=' . $_REQUEST['user_email']);
            }
            else
            {
                $_REQUEST['user_email'] = $_REQUEST['login_phone_prefix'] . $_REQUEST['user_email'];
                fn_csc_check_phone_format($_REQUEST['user_email']);

                $condition = '';

                if (Registry::get('settings.Stores.share_users') == 'N') {
                    $condition .= db_quote(' AND company_id = ?i ', Registry::get('runtime.company_id'));
                }

                $user_id = db_get_field('SELECT user_id FROM ?:users WHERE phone = ?s ?p', $_REQUEST['user_email'], $condition);
                if (!empty($user_id)) {
                    $password = fn_csc_create_new_password($user_id);

                    fn_csc_send_sms($_REQUEST['user_email'], __('csc_password_was_changed', array('[new_password]' => $password)));

                    fn_set_notification('N', __('notice'), __('csc_we_send_new_password_to_your_phone', array('[phone]' => $_REQUEST['user_email'])));
                    return array(CONTROLLER_STATUS_REDIRECT, 'auth.login_form?phone=' . $_REQUEST['user_email']);
                }
            }
        }

        fn_set_notification('E', __('error'), __('csc_user_not_found'));
        return array(CONTROLLER_STATUS_REDIRECT, 'auth.recover_password');
    }

    return;
}

if ($mode == 'change_login') {
    if (isset($_SESSION['login_data'])) {
        unset($_SESSION['login_data']);
    }
}