<?php
use Tygh\Registry;
use Tygh\Http;
require_once 'hooks.php';

function fn_csc_check_phone_format(&$phone)
{
    if (empty($phone)) {
        return;
    }
    $phone = '+' . preg_replace("/[^0-9]/", '', $phone);
}

function fn_csc_create_new_password($user_id)
{
    $new_password = fn_generate_password();
    $salt = fn_generate_salt();

    $user_data = array(
        'salt' => $salt,
        'password' => fn_generate_salted_password($new_password, $salt)
    );

    if (!empty($user_id)) {
        db_query('UPDATE ?:users SET ?u WHERE user_id = ?i', $user_data, $user_id);
    }

    return $new_password;
}

function fn_csc_send_sms($phone, $text)
{
    $addon = Registry::get('addons.csc_sms');
    fn_csc_check_phone_format($phone);
    if ($addon['service'] == 'smsru')
    {
        $data = array(
            'api_id' => $addon['sms_api_key'],
            'to' => $phone,
            'msg' => $text,
            'json' => 1
        );
        $url = 'https://sms.ru/sms/send';
        $result = Http::get($url, $data);
        $result = json_decode($result);
    }
    if ($addon['service'] == 'turbosms')
    {
        $client = new SoapClient('http://turbosms.in.ua/api/wsdl.html');
        $auth = [
            'login' => $addon['turbosms_login'],
            'password' => $addon['turboms_pass']
        ];
        $result = $client->Auth($auth);
        $text = iconv('windows-1251', 'utf-8', $text);
        $sms = [
            'sender' => $addon['turbosms_sender'],
            'destination' => $phone,
            'text' => $text
        ];
        $result = $client->SendSMS($sms);
    }

    if ($addon['service'] == 'targetsms')
    {
        require_once 'app/addons/csc_sms/lib/sms.class.php';

        $messages = new \Sms\Xml\Messages($addon['targetsms_login'], $addon['targetsms_pass']);
        $messages->setUrl('https://sms.targetsms.ru');
        $mes = $messages->createNewMessage($addon['targetsms_sender'], $text, 'sms');

        $abonent = $mes->createAbonent($phone);
        $abonent->setNumberSms(1);
        $mes->addAbonent($abonent);

        $messages->addMessage($mes);
        if (!$messages->send()) {
            fn_log_event('csc_sms', 'csc_sms_request', array(
                'phone' => $phone,
                'text' => $text,
                'res' => $messages->getError()
            ));
        } else {
            fn_log_event('csc_sms', 'csc_sms_request', array(
                'phone' => $phone,
                'text' => $text,
                'res' => $messages->getResponse()
            ));
        }
    }

    if ($addon['service'] == 'osonsms')
    {
        require_once 'app/addons/csc_sms/lib/osonsms.php';
        $config = array(
            'login' => $addon['osonsms_login'],
            'hash' => $addon['osonsms_hash'],
            'sender' => $addon['osonsms_sender'],
            'server' => OSONSMSURL
        );

        $dlm = ";";
        $phone_number = $phone;
        $txn_id = uniqid() . time();
        $str_hash = hash('sha256',$txn_id.$dlm.$config['login'].$dlm.$config['sender'].$dlm.$phone_number.$dlm.$config['hash']);
        $params = array(
            "from" => $config['sender'],
            "phone_number" => $phone_number,
            "msg" => $text,
            "str_hash" => $str_hash,
            "txn_id" => $txn_id,
            "t" => 23,
            "login"=>$config['login'],
        );
        $result = call_api($config['server'], "GET", $params);
        if ((isset($result['error']) && $result['error'] == 0))
        {
            $response = json_decode($result['msg'], 1);
            fn_log_event('csc_sms', 'csc_sms_request', array(
                'phone' => $phone,
                'text' => $text,
                'res' => @$result['sms_msg_status']
            ));
        }
        else
        {
            fn_log_event('csc_sms', 'csc_sms_request', array(
                'phone' => $phone,
                'text' => $text,
                'res' => 'error ' . $result['msg']
            ));
        }
    }

    if (!empty($result))
    {
        fn_log_event('csc_sms', 'csc_sms_request', array(
            'phone' => $phone,
            'text' => $text,
            'res' => serialize($result)
        ));
    }

    return true;
}

function fn_scs_get_phone_by_user_id($user_id)
{
    if (empty($user_id)) {
        return '';
    }

    return db_get_field('SELECT phone FROM ?:users WHERE user_id = ?i', $user_id);
}

function fn_csc_generate_code()
{
    $cnt = Registry::get('addons.csc_sms.numbers_cnt');
    $from = '';
    $to = '';
    for ($i = 1;$i <= $cnt; $i++)
    {
        $from .= '1';
        $to .= '9';
    }

    return rand($from, $to);
}

function fn_settings_variants_addons_csc_sms_only_countries()
{
    $countries = db_get_array('select code, country from ?:country_descriptions where lang_code = ?s', DESCR_SL);

    $result = array();
    foreach($countries as $country)
    {
        $result[fn_strtolower($country['code'])] = $country['country'];
    }

    return $result;
}

function fn_settings_variants_addons_csc_sms_prefered_countries()
{
    $countries = db_get_array('select code, country from ?:country_descriptions where lang_code = ?s', DESCR_SL);

    $result = array();
    foreach($countries as $country)
    {
        $result[fn_strtolower($country['code'])] = $country['country'];
    }

    return $result;
}