<?php

use Tygh\Registry;

function fn_csc_sms_update_user_pre($user_id, &$user_data, $auth, $ship_to_another, &$notify_user)
{
    if (AREA == 'C' && empty($user_id)) {
        $notify_user = false;
    }

    if (AREA == 'C' && !empty($user_data['email']) && $user_data['email'] == TMP_EMAIL_VALUE) {
        $user_data['email'] = '';
    }

    if (!empty($user_data['phone'])) {
        $user_data['phone'] = @$user_data['phone_prefix'] . $user_data['phone'];
        fn_csc_check_phone_format($user_data['phone']);
    }
}

function fn_csc_sms_pre_place_order(&$cart, $allow, $product_groups)
{
    $cart['user_data']['phone'] = $_REQUEST['prefix_user_data']['phone'] . $cart['user_data']['phone'];
    fn_csc_check_phone_format($cart['user_data']['phone']);
    if (!empty($cart['user_data']['email'])) {
        if ($cart['user_data']['email'] == TMP_EMAIL_VALUE) {
            $cart['user_data']['email'] = '';
        }
    }
}

function fn_csc_sms_get_user_info($user_id, $get_profile, $profile_id, $user_data)
{
    if (empty($user_data['s_phone']) && !empty($user_data['phone'])) {
        $user_data['s_phone'] = $user_data['phone'];
    }
}

function fn_csc_sms_send_mail_pre($transport, &$message, $area, $lang_code)
{
    if ($message['to'] == TMP_EMAIL_VALUE) {
        $message['to'] = '';
    }
}

function fn_csc_sms_is_user_exists_post($user_id, $user_data, &$is_exist)
{
    if (!$is_exist) {
        if (!empty($user_data['phone'])) {
            $condition = '';

            if (!empty($user_id)) {
                $condition .= db_quote(" AND user_id != ?i", $user_id);
            }

            if (Registry::get('settings.Stores.share_users') == 'N') {
                $condition .= db_quote(' AND company_id = ?i ', Registry::get('runtime.company_id'));
            }

            $is_exist = db_get_field('SELECT user_id FROM ?:users WHERE phone = ?s ?p', $user_data['phone'], $condition);
        }
    }
}

function fn_csc_sms_auth_routines($request, $auth, &$field, $condition, &$user_login)
{
    if (!empty($request['user_login_phone'])) $user_login = $request['login_phone_prefix'] . $request['user_login_phone'];
    if (!empty($request['user_login_phone_code'])) $user_login = $request['login_phone_prefix'] . $request['user_login_phone_code'];
    if (!empty($user_login) && AREA == 'C')
    {
        if ($request['login_type'] == 'sms' || $request['login_type'] == 'sms_code')
        {
            fn_csc_check_phone_format($user_login);
            $field = 'phone';
        }
        else $field = 'email';
    }
}

function fn_csc_sms_update_profile($action, $user_data, $current_user_data)
{
    if (AREA == 'C' && $action == 'add') {
        fn_csc_send_sms($user_data['phone'], __('csc_thank_you_for_the_registration', array('[phone]' => $user_data['phone'])));
    }
}

function fn_csc_sms_get_users($params, &$fields, $sortings, $condition, $join, $auth)
{
    $fields[] = '?:users.phone';
}

function fn_csc_sms_place_order($order_id, $action, $order_status, $cart, $auth)
{
    
}

function fn_csc_sms_update_gift_certificate_post($gc_data, $gift_cert_id, $gift_cert_data)
{
    if (!empty($gift_cert_data['send_sms']) && $gift_cert_data['send_sms'] == 'Y' && !empty($gift_cert_data['sms_phone'])) {

        if (!empty($gc_data['gift_cert_code'])) {
            fn_csc_send_sms($gift_cert_data['sms_phone'], __('the_gift_cert_was_generated_for_you', array('[gift_cert_code]' => $gc_data['gift_cert_code'])));

            fn_set_notification('N', __('notice'), __('cert_code_was_sent_to_phone', array('[phone]' => $gift_cert_data['sms_phone'])));
        }
    }
}

function fn_csc_sms_gift_certificate_notification($gift_cert_data, $force_notification)
{
    if (!empty($_SESSION['cart']['gift_certificates'])) {
        foreach ($_SESSION['cart']['gift_certificates'] as $gfd) {
			if ($gfd['gift_cert_code'] != $gift_cert_data['gift_cert_code']) continue;
            if (!empty($gfd['extra']['send_sms']) && $gfd['extra']['send_sms'] == 'Y' && !empty($gfd['extra']['sms_phone'])) {
                if (!empty($gfd['gift_cert_code'])) {
                    fn_csc_send_sms($gfd['extra']['sms_phone'], __('the_gift_cert_was_generated_for_you', array('[gift_cert_code]' => $gfd['gift_cert_code'])));
                    fn_set_notification('N', __('notice'), __('cert_code_was_sent_to_phone', array('[phone]' => $gfd['extra']['sms_phone'])));
                }
            }
        }
    }
}

function fn_csc_sms_generate_password_pre(&$chars)
{
	$chars = '1234567890';
}

function fn_csc_sms_change_order_status($status_to, $status_from, $order_info, $force_notification, $order_statuses, $place_order)
{
	$status_data = fn_get_status_params($status_to);
    if (!empty($order_info['s_phone'])) {
		if ($status_data['grant_reward_points'] == "Y")
		{
			$points_text = '';
			if ($order_info['user_id']) {
				$user_info = fn_get_user_info($order_info['user_id']);
				if (!empty($user_info)) {
					if (!empty($user_info['points'])) {
						$points_text = __('you_have_n_points', array('[points]' => $user_info['points']));
					}
				}
			} else {
				if (!empty($_SESSION['cart']['points_info']['reward'])) {
					$points_text = __('you_have_n_points', array('[points]' => $_SESSION['cart']['points_info']['reward']));
				}
			}
			//fn_csc_send_sms($order_info['s_phone'], $points_text);
		}
		
		if ($status_to == 'O') 
		{
			$points_text = '';

			$sms_text = __('thank_you_for_the_placing_order', array('[invoice_url]' => fn_url('orders.print_invoice?order_id=' . $order_info['order_id'], 'C'), '[points_text]' => $points_text));

			//fn_csc_send_sms($order_info['s_phone'], $sms_text);
		}
    }
}