<?php

class Plugin_Osonsms_p233218 extends Plugin
{
    public function init()
    {
        parent::init();

        $this->setSettings(array(
            'extension_id'   => 'p2332180d34f44c341ba2602deb454658bbcf261',
            'plugin_title'   => 'Интеграция с сервисом ОсонСМС',
            'plugin_version' => '1.0.0',
        ));

        /**
         * Настройки заполняемые в админ. панели
         */
        $this->configSettings(array(
            'api_key' => [
                'title' => $this->langAdmin('Уникальный ключ (api_key)'),
                'type' => TYPE_STR,
                'input' => 'text',
                'default' => '',
                'placeholder' => $this->langAdmin('Например: [code]', [
                    'code' => '4ac0c9c0-25xx-77f4-ed29-1519e8719180',
                ]),
            ],
            'login' => [
                'title' => $this->langAdmin('Логин в ОсонСМС'),
                'type' => TYPE_STR,
                'input' => 'text',
                'placeholder' => 'dodo',
                'description' => '',
            ],
            'from' => [
                'title' => $this->langAdmin('Имя отправителя'),
                'type' => TYPE_STR,
                'input' => 'text',
                'placeholder' => 'dodo.tj',
                'description' => '',
            ],
            /* permanently disabled
            'test' => [
                'title' => $this->langAdmin('Тестовая отправка'),
                'type' => TYPE_BOOL,
                'input' => 'select',
                'default' => false,
                'options' => [
                    true => ['title' => _t('', 'включено')],
                    false => ['title' => _t('', 'выключено')],
                ],
            ],
            */
    ));
    }

    protected function start()
    {
        // Код плагина
                bff::hooks()->add('users.sms.send', array($this, 'send'));
        # Добавляем провайдера в список в системную настройку "SMS провайдер"
        bff::hooks()->add('users.sms.provider.list', function($list){
            $list['sms_osonsms_com'] = array('title'=>'osonsms.com');
            return $list;
        });
    }

        public function send($provider, $phoneNumber, $message)
    {
        if ($provider !== 'sms_osonsms_com') {
            return $provider;
        }

        $api_key = $this->config('api_key');
        if (empty($api_key)) {
            $this->log('Необходимо указать системную настройку "Уникальный ключ (api_key)"');
            return false;
        }


        $config = array(
            'login' => $this->config('login'),  // Ваш логин, который выдается администратором OsonSMS
            'hash' => $api_key,  // Ваш хэш, который выдается администратором OsonSMS
            'sender' => $this->config('from'), // 'Альфанумерик, СМС отправитель'
            'server' => 'https://api.osonsms.com/sendsms_v1.php' // 'Адрес сервера'
        );
        function call_api($url, $method, $params){
            $curl = curl_init();
            $data = http_build_query ($params);
            if ($method == "GET") {
                curl_setopt ($curl, CURLOPT_URL, "$url?$data");
            }else if($method == "POST"){
                curl_setopt ($curl, CURLOPT_URL, $url);
                curl_setopt ($curl, CURLOPT_POSTFIELDS, $data);
            }else if($method == "PUT"){
                curl_setopt ($curl, CURLOPT_URL, $url);
                curl_setopt ($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded','Content-Length:'.strlen($data)));
                curl_setopt ($curl, CURLOPT_POSTFIELDS, $data);
            }else if ($method == "DELETE"){
                curl_setopt ($curl, CURLOPT_URL, "$url?$data");
                curl_setopt ($curl, CURLOPT_CUSTOMREQUEST, "DELETE");
            }else{
                dd("unkonwn method");
            }
            curl_setopt_array($curl, array(
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => $method
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);
            $arr = array();
            if ($err) {
                $arr['error'] = 1;
                $arr['msg'] = $err;
            } else {
                $res = json_decode($response);
                if (isset($res->error)){
                    $arr['error'] = 1;
                    $arr['msg'] = "Error Code: ". $res->error->code . " Message: " . $res->error->msg;
                }else{
                    $arr['error'] = 0;
                    $arr['msg'] = $response;
                }
            }
            return $arr;
        }

        $dlm = ";";
        $phone_number = $phoneNumber; //номер телефона
        $txn_id = uniqid(); //ID сообщения в вашей базе данных, оно должно быть уникальным для каждого сообщения
        $str_hash = hash('sha256',$txn_id.$dlm.$config['login'].$dlm.$config['sender'].$dlm.$phone_number.$dlm.$config['hash']);
        #$message = $message;
        $params = array(
            "from" => $config['sender'],
            "phone_number" => $phone_number,
            "msg" => $message,
            "str_hash" => $str_hash,
            "txn_id" => $txn_id,
            "login"=>$config['login'],
        );
        $result = call_api($config['server'], "GET", $params);

        if ((isset($result['error']) && $result['error'] == 0)){
            $response = json_decode($result['msg']);
            #print_r($response);
            return true;
            /* так выглядет ответ сервера
             * {
                    "status": "ok",
                    "timestamp": "2017-07-07 16:58:12",
                    "txn_id": "f890b43b964c2801f62b61a9662efff96dbaa82e007bc60c22ec41d9b22a3e0b",
                    "msg_id": 40127,
                    "smsc_msg_id": "45f22479",
                    "smsc_msg_status": "success",
                    "smsc_msg_parts": 1
                }
             */
            #echo "success: ".$response->msg_id; // id сообщения для проверки статуса сообщения в спорных случаях
        }else{
            #print_r($result);
            #echo "error occured ".$result['msg'];
            $this->errors->set(_t('users', $result['msg']));
            $this->log('Ошибка отправки сообщения #'.strval($txn_id).' - '.$result['msg']);
            $this->log($body);
        }
    }
}